/*
 * Decompiled with CFR 0.152.
 */
package gloridifice.watersource.common.recipe.type;

import gloridifice.watersource.common.item.StrainerBlockItem;
import gloridifice.watersource.helper.FluidHelper;
import gloridifice.watersource.registry.FluidRegistry;
import gloridifice.watersource.registry.ItemRegistry;
import gloridifice.watersource.registry.RecipeSerializersRegistry;
import java.util.ArrayList;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class PurifiedWaterCupRecipe
extends SpecialRecipe {
    protected Fluid fluid = (Fluid)FluidRegistry.PURIFIED_WATER.get();
    protected ResourceLocation strainerTag = new ResourceLocation("watersource", "purification_strainers");

    public PurifiedWaterCupRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        boolean hasStrainer = false;
        boolean hasPotion = false;
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            ITag tag = ItemTags.func_199903_a().func_199910_a(this.strainerTag);
            if (tag != null && tag.func_230235_a_((Object)itemstack.func_77973_b())) {
                list.add(itemstack);
                hasStrainer = true;
            }
            if (itemstack.func_77973_b() != ItemRegistry.WOODEN_CUP_DRINK || !ItemStack.func_77970_a((ItemStack)itemstack, (ItemStack)FluidHelper.fillContainer(new ItemStack((IItemProvider)ItemRegistry.WOODEN_CUP_DRINK), (Fluid)Fluids.field_204546_a))) continue;
            list.add(itemstack);
            hasPotion = true;
        }
        return hasPotion && hasStrainer && list.size() == 2;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        return this.func_77571_b();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            ITag tag = ItemTags.func_199903_a().func_199910_a(this.strainerTag);
            if (itemstack.func_190926_b() || tag == null || !tag.func_230235_a_((Object)itemstack.func_77973_b())) continue;
            ItemStack i = StrainerBlockItem.damageItem(itemstack.func_77946_l(), 1);
            nonnulllist.set(j, (Object)i);
        }
        return nonnulllist;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RecipeSerializersRegistry.CRAFTING_PURIFIED_WATER_CUP.get();
    }

    public ItemStack func_77571_b() {
        return FluidHelper.fillContainer(new ItemStack((IItemProvider)ItemRegistry.WOODEN_CUP_DRINK), this.fluid);
    }
}

